import java.util.Random;

public class Patient {
    private final String name;
    private int severity; // Severity from 1 (lowest) to 10 (highest)

    public Patient(String name) {
        this.name = name;
        this.severity = examine();
    }

    // Simulate examination by assigning random severity between 1 and 10
    private int examine() {
        Random random = new Random();
        return random.nextInt(10) + 1;
    }

    public String getName() {
        return name;
    }

    public int getSeverity() {
        return severity;
    }

    public void increaseSeverity() {
        severity++;
    }

    @Override
    public String toString() {
        return name + " (severity: " + severity + ")";
    }
}